require "prefabutil"

local assets =
{
    Asset("ANIM", "anim/millbuilder.zip"),
	Asset("ATLAS", "images/inventoryimages/millbuilder.xml")
}

local prefabs =
{
    "collapse_small",
	"flint",
	"poop",
}

local function onhammered(inst, worker)
    if inst.components.burnable ~= nil and inst.components.burnable:IsBurning() then
        inst.components.burnable:Extinguish()
    end
    local x, y, z = inst.Transform:GetWorldPosition()
    SpawnPrefab("goldnugget").Transform:SetPosition(x, y, z)
	SpawnPrefab("boards").Transform:SetPosition(x, y, z)
    
    inst:Remove()
end

local function onhit(inst, worker)
	inst.AnimState:PlayAnimation("hit")
	inst.AnimState:PushAnimation("idle", true)
end


local function onbuilt(inst)
    inst.SoundEmitter:PlaySound("dontstarve/common/sign_craft")
end
--分解系统
local function OnGetItemFromPlayer(inst, giver, item)
local x, y, z = inst.Transform:GetWorldPosition()
y = 1
x = x+2
--金块=大块金属+碳
    if item.prefab == "goldnugget" 
	then 
	inst.AnimState:PlayAnimation("idle")
	SpawnPrefab("c").Transform:SetPosition(x, y, z)
	for k = 1, 2 do
    SpawnPrefab("coherer").Transform:SetPosition(x, y, z) end
	
    end
--燧石=金属碎片
	if item.prefab == "flint" 
	then 
	inst.AnimState:PlayAnimation("idle")
	for k = 1, 2 do
    SpawnPrefab("coherer_small").Transform:SetPosition(x, y, z) end
    end
--大块金属=铁+铜
	if item.prefab == "coherer" 
	then 
	inst.AnimState:PlayAnimation("idle")
    SpawnPrefab("cu").Transform:SetPosition(x, y, z)
	SpawnPrefab("fe").Transform:SetPosition(x, y, z)
    end
--粪便=糊糊
	  if item.prefab == "poop"
	then
	inst.AnimState:PlayAnimation("idle")
    SpawnPrefab("huhu",1).Transform:SetPosition(x, y, z)
	SpawnPrefab("huhu",1).Transform:SetPosition(x, y, z)
	end
--草，芦苇=植物纤维
  if item.prefab == "cutgrass" 
	then
	inst.AnimState:PlayAnimation("idle")
    SpawnPrefab("fibre",1).Transform:SetPosition(x, y, z)
	end
	if item.prefab == "cutreeds"
	then
	inst.AnimState:PlayAnimation("idle")
    SpawnPrefab("fibre",1).Transform:SetPosition(x, y, z)
	end
--怪兽肉=肉筋+怪物废料+遗传物质
 if item.prefab == "monstermeat" 
	then
	inst.AnimState:PlayAnimation("idle")
    SpawnPrefab("garbage",1).Transform:SetPosition(x, y, z)
	SpawnPrefab("tendon",1).Transform:SetPosition(x, y, z)
	SpawnPrefab("dna",1).Transform:SetPosition(x, y, z)
	end
--石头=铅+金属碎片
if item.prefab == "rocks" 
	then 
	inst.AnimState:PlayAnimation("idle")
    SpawnPrefab("pb").Transform:SetPosition(x, y, z)
	SpawnPrefab("coherer_small").Transform:SetPosition(x, y, z)
    end
--小肉=骨头碎片+遗传物质
if item.prefab == "smallmeat" 
	then
	inst.AnimState:PlayAnimation("idle")
    SpawnPrefab("boneshard",1).Transform:SetPosition(x, y, z)
	SpawnPrefab("dna",1).Transform:SetPosition(x, y, z)
	end
--蜘蛛丝=真丝纤维
if item.prefab == "silk" 
	then
	inst.AnimState:PlayAnimation("idle")
	SpawnPrefab("tsilk",1).Transform:SetPosition(x, y, z)
	end
--大肉=遗传物质+皮革+肉筋
if item.prefab == "meat" 
	then
	inst.AnimState:PlayAnimation("idle")
    SpawnPrefab("tendon",1).Transform:SetPosition(x, y, z)
	SpawnPrefab("dna",1).Transform:SetPosition(x, y, z)
	SpawnPrefab("leather",1).Transform:SetPosition(x, y, z)
	end
--种子=细胞材料
if item.prefab == "seeds" 
	then
	inst.AnimState:PlayAnimation("idle")
    SpawnPrefab("cell",1).Transform:SetPosition(x, y, z)
	end
	
--沙子地皮=沙子
if item.prefab == "turf_desertdirt" 
	then
	inst.AnimState:PlayAnimation("idle")
    SpawnPrefab("sand",1).Transform:SetPosition(x, y, z)
	end
--小麦=面粉
if item.prefab == "maizi" 
	then
	inst.AnimState:PlayAnimation("idle")
    SpawnPrefab("flour",1).Transform:SetPosition(x, y, z)
	end
end

local function OnRefuseItem(inst, giver, item)
    inst.SoundEmitter:PlaySound("dontstarve/pig/PigKingReject")
    inst.AnimState:PlayAnimation("hit")
end
local function fn()
    local inst = CreateEntity()
    inst.entity:AddTransform()
    inst.entity:AddAnimState()
    inst.entity:AddSoundEmitter()
    inst.entity:AddNetwork()
    MakeObstaclePhysics(inst, .2)
	inst.entity:AddDynamicShadow()
	inst.DynamicShadow:SetSize( 2,2 )
    inst.AnimState:SetBank("millbuilder")
    inst.AnimState:SetBuild("millbuilder")
    inst.AnimState:PlayAnimation("idle")
    MakeSnowCoveredPristine(inst)
    inst:AddTag("structure")
    inst:AddTag("sign")
    inst.entity:SetPristine()
    if not TheWorld.ismastersim then
        return inst
    end
	--分解
     inst:AddComponent("trader")
	 inst.components.trader:SetAcceptTest(function(inst,item)
	 if item.prefab == "poop" or item.prefab == "goldnugget" or item.prefab == "flint" or item.prefab == "cutgrass"  or item.prefab == "coherer"  or item.prefab == "cutreeds" or item.prefab == "monstermeat" or item.prefab == "silk" or item.prefab == "meat" or item.prefab == "smallmeat" or item.prefab == "seeds" or item.prefab == "turf_desertdirt" 
	 then
	 return true
	 end
	 return false
	 end)
	 inst.components.trader.onaccept = OnGetItemFromPlayer
	
	inst:AddComponent("workable")
    inst.components.workable:SetWorkAction(ACTIONS.HAMMER)
    inst.components.workable:SetWorkLeft(5)
    inst.components.workable:SetOnFinishCallback(onhammered)
    inst.components.workable:SetOnWorkCallback(onhit)
    inst:AddComponent("inspectable")
    inst:AddComponent("lootdropper")
	   inst:ListenForEvent("onbuilt", onbuilt)
	   MakeHauntableWork(inst)
    return inst
end
return Prefab("millbuilder", fn, assets, prefabs),
    MakePlacer("millbuilder_placer", "millbuilder", "millbuilder", "idle")
